% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.permTestResultsList.R
\name{plot.permTestResultsList}
\alias{plot.permTestResultsList}
\title{Function for plotting the results from a \code{permTestResultsList} object when more than one evaluation function was used.}
\usage{
\method{plot}{permTestResultsList}(
  x,
  ncol = NA,
  pvalthres = 0.05,
  plotType = "Tailed",
  main = "",
  xlab = NULL,
  ylab = "",
  ...
)
}
\arguments{
\item{x}{an object of class \code{permTestResultsList}.}

\item{ncol}{number of plots per row. ncol=NA means ncol=floor(sqrt(length(x)))so the plot is more or less square (default=NA)}

\item{pvalthres}{p-value threshold for significance. Default is 0.05.}

\item{plotType}{the type of plot to display. This must be one of \code{"Area"} or \code{"Tailed"}. Default is \code{"Area"}.}

\item{main}{a character specifying the title of the plot. Defaults to "".}

\item{xlab}{a character specifying the label of the x axis. Defaults to NULL, which produces a plot with the evaluation function name as the x axis label.}

\item{ylab}{a character specifying the label of the y axis. Defaults to "".}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A plot is created on the current graphics device.
}
\description{
Function for plotting the results from a \code{permTestResultsList} object when more than one evaluation function was used.
}
\examples{

genome <- filterChromosomes(getGenome("hg19"), keep.chr="chr1")
A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=20000, genome=genome, non.overlapping=FALSE) 
B <- c(A, createRandomRegions(nregions=10, length.mean=10000, length.sd=20000, genome=genome, non.overlapping=FALSE))

pt <- overlapPermTest(A=A, B=B, ntimes=10, genome=genome, non.overlapping=FALSE)
summary(pt)
plot(pt)
plot(pt, plotType="Tailed")  
 
pt2 <- permTest(A=A, B=B, ntimes=10, alternative="auto", genome=genome, evaluate.function=list(distance=meanDistance, numberOfOverlaps=numOverlaps), randomize.function=randomizeRegions, non.overlapping=FALSE)
summary(pt2)
plot(pt2)
plot(pt2, plotType="Tailed")

}
\seealso{
\code{\link{permTest}}
}
