% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMask.R
\name{getMask}
\alias{getMask}
\title{getMask}
\usage{
getMask(genome)
}
\arguments{
\item{genome}{the genome from where the mask will be extracted. It can be either a \code{\link{BSgenome}} object or a character string uniquely identifying a \code{\link{BSgenome}} object installed (e.g. "hg19", "mm10", ...)}
}
\value{
A \code{\link{GRanges}} object with the genomic regions to be masked out
}
\description{
Function to obtain a mask given a genome available as a \code{\link{BSgenome}}. The mask returned is the merge of all the active masks in the \code{\link{BSgenome}}.

Since it uses \code{\link{characterToBSGenome}}, the genome can be either a \code{\link{BSgenome}} object or a character string uniquely identifying the a \code{\link{BSgenome}} object installed.
}
\note{
This function is memoised (cached) using the \code{\link{memoise}} package. To empty the cache, use \code{\link{forget}(getMask)}
}
\examples{
hg19.mask <- getMask("hg19")

hg19.mask

}
\seealso{
\code{\link{getGenome}}, \code{\link{getGenomeAndMask}}, \code{\link{characterToBSGenome}}, \code{\link{maskFromBSGenome}}, \code{\link{emptyCacheRegioneR}}
}
