% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenomeAndMask.R
\name{getGenomeAndMask}
\alias{getGenomeAndMask}
\title{getGenomeAndMask}
\usage{
getGenomeAndMask(genome, mask=NULL)
}
\arguments{
\item{genome}{the genome object or genome identifier.}

\item{mask}{the mask of the genome in a valid RS format (data.frame, GRanges, BED-like file...). If mask is \code{\link{NULL}}, it will try to get a mask from the genome. If mask is \code{\link{NA}} it will return an empty mask. (Default=NULL)}
}
\value{
A list with two elements: genome and mask. Genome and mask are GRanges objects.
}
\description{
Function to obtain a valid genome and mask pair given a valid genome identifier and optionally a mask. 

If the genome is not a \code{\link{BSgenome}} object or a character string uniquely identifying a \code{\link{BSgenome}} package installed, it will return the genome "as is". If a mask is provided, it will simply return it. Otherwise it will return the mask returned by \code{\link{getMask}(genome)} or an empty mask if genome is not a valid \code{\link{BSgenome}} or \code{\link{BSgenome}} identifier.
}
\note{
This function is memoised (cached) using the \code{\link{memoise}} package. To empty the cache, use \code{\link{forget}(getGenomeAndMask)}
}
\examples{
getGenomeAndMask("hg19", mask=NA)

getGenomeAndMask(genome=data.frame(c("chrA", "chrB"), c(15000000, 10000000)), mask=NA)

}
\seealso{
\code{\link{getMask}}, \code{\link{getGenome}}, \code{\link{characterToBSGenome}}, \code{\link{maskFromBSGenome}}, \code{\link{emptyCacheRegioneR}}
}
