% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{matchds_1to2}
\alias{matchds_1to2}
\title{Match two datasets on rows and columns}
\usage{
matchds_1to2(
  ds1,
  ds2,
  mi1 = c("rows", "columns"),
  mi2 = c("rows", "columns"),
  subset.match = FALSE
)
}
\arguments{
\item{ds1}{First dataset to match}

\item{ds2}{Second dataset to match}

\item{mi1}{Match index of ds1 (either "rows" or "columns")}

\item{mi2}{Match index of ds2 (either "rows" or "columns")}

\item{subset.match}{If index lengths don't match, match on the 
common subset instead}
}
\value{
A list of the matched datasets.
}
\description{
Match 2 datasets using the character vectors of row or column 
names. This is used to assemble an "RGChannelSet" from a query 
to an h5 dataset.
}
\examples{
# get 2 data matrices
ds1 <- matrix(seq(1, 10, 1), nrow = 5)
ds2 <- matrix(seq(11, 20, 1), nrow = 5)
rownames(ds1) <- rownames(ds2) <- paste0("row", seq(1, 5, 1))
colnames(ds1) <- colnames(ds2) <- paste0("col", c(1, 2))
ds2 <- ds2[rev(seq(1, 5, 1)), c(2, 1)]
# match row and column names
lmatched <- matchds_1to2(ds1, ds2, mi1 = "rows", mi2 = "rows")
lmatched <- matchds_1to2(lmatched[[1]], lmatched[[2]], mi1 = "columns", 
 mi2 <- "columns")
# check matches
ds1m <- lmatched[[1]]
ds2m <- lmatched[[2]]
identical(rownames(ds1m), rownames(ds2m))
identical(colnames(ds1m), colnames(ds2m))
}
