% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_db.R
\name{get_rmdl}
\alias{get_rmdl}
\title{Get DNAm assay data.}
\usage{
get_rmdl(
  which.class = c("rg", "gm", "gr", "test"),
  which.type = c("h5se", "h5"),
  which.platform = c("hm450k", "epic"),
  fn = NULL,
  dfp = "downloads",
  url = "https://methylation.recount.bio/",
  show.files = FALSE,
  download = TRUE,
  sslver = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{which.class}{Either "rg", "gm", "gr", or "test" for RGChannelSet, 
MethylSet, GenomicRatioSet, or 2-sample subset.}

\item{which.type}{Either "h5se" for an HDF5-SummarizedExperiment or 
"h5" for an HDF5 database.}

\item{which.platform}{Supported DNAm array platform type. Currently 
supports either "epic" for EPIC/HM850K, or "hm450k" for HM450K.}

\item{fn}{Name of file on server to download (optional, default NULL).}

\item{dfp}{Download destination directory (default "downloads").}

\item{url}{The server URL to locate files for download.}

\item{show.files}{Whether to print server file data to console (default 
FALSE).}

\item{download}{Whether to download (TRUE) or return queried filename 
(FALSE).}

\item{sslver}{Whether to use server certificate check (default FALSE).}

\item{verbose}{Whether to return verbose messages (default TRUE).}
}
\value{
New filepath to dir containing the downloaded data.
}
\description{
Uses RCurl to download the latest HDF5-SummarizedExperiment or HDF5 
database compilation files objects from the server. Calls servermatrix 
and performs various quality checks to validate files and downloads. 
This function is wrapped in the getdb() set of functions (type `?getdb` for 
details).
}
\examples{
# prints file info from server:
path <- try(get_rmdl(which.class = "test", which.type = "h5se", 
show.files = TRUE, download = FALSE))
}
\seealso{
servermatrix(), getURL(), loadHDF5SummarizedExperiment(), h5ls()
}
