% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_control_metrics.R
\name{get_qcsignal}
\alias{get_qcsignal}
\title{get_qcsignal}
\usage{
get_qcsignal(se = NULL, mm = NULL, mu = NULL, sample_idv = NULL)
}
\arguments{
\item{se}{Valid SummarizedExperiment object, such as a MethylSet or similar object
for which getMeth() and getUnmeth() methods are defined (optional).}

\item{mm}{Matrix of methylated/M signals (optional, not required if se provided).}

\item{mu}{Matrix of unmethylated/U signals (optional, not required if se provided).}

\item{sample_idv}{Vector of sample IDs to label rows in the returned data frame 
(optional, uses mm colnames instead if not provided).}
}
\value{
Data frame of signal summaries.
}
\description{
Get the medians of the log2-transformed M and U signals. This function 
uses the DelayedMatrixStats implementations of colMedians for rapid
calculations on DelayedArray-formatted matrices.
}
\details{
Calculates the log2 of median signal for methylated/M and 
unmethylated/U signals separately.
}
\examples{
library(minfiData)
data(MsetEx)
se <- MsetEx
class(se)
# [1] "MethylSet"
# attr(,"package")
# [1] "minfi"
ms <- get_qcsignal(se)
}
\seealso{
bactrl
}
