% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_url_ann.R
\name{locate_url_ann}
\alias{locate_url_ann}
\title{Construct the URL to a recount3 annotation file}
\usage{
locate_url_ann(
  type = c("gene", "exon"),
  organism = c("human", "mouse"),
  annotation = annotation_options(organism),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3")
)
}
\arguments{
\item{type}{A \code{character(1)} specifying whether you want to access gene
counts or exon data.}

\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{annotation}{A \code{character(1)} specifying which annotation you want to
download. Only used when \code{type} is either \code{gene} or \code{exon}.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}
}
\value{
A \code{character(1)} with the URL (or file path) to access the
recount3 annotation file.
}
\description{
Given a expression feature \code{type}, \code{organism} and \code{annotation}, this
function constructs the URL (or file path) to access a recount3
annotation file. This function is used by \code{create_rse_manual()}.
}
\examples{

locate_url_ann()
locate_url_ann(organism = "mouse")
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url}()},
\code{\link{project_homes}()},
\code{\link{read_counts}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
