% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_projects.R
\name{available_projects}
\alias{available_projects}
\title{List available projects in recount3}
\usage{
available_projects(
  organism = c("human", "mouse"),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3"),
  bfc = recount3_cache(),
  available_homes = project_homes(organism = organism, recount3_url = recount3_url)
)
}
\arguments{
\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}

\item{bfc}{A \link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}
object where the files will be cached to, typically created by
\code{recount3_cache()}.}

\item{available_homes}{A \code{character()} vector with the available project homes
for the given \code{recount3_url}. If you use a non-standard \code{recount3_url}, you
will likely need to specify manually the valid values for \code{available_homes}.}
}
\value{
A \code{data.frame()} with the project ID (\code{project}), the \code{organism}, the
\code{file_source} from where the data was accessed,
the \code{recount3} project home location (\code{project_home}), the project
\code{project_type} that differentiates between \code{data_sources} and \code{compilations},
the \code{n_samples} with the number of samples in the given project.
}
\description{
List available projects in recount3
}
\examples{

## Find all the human projects
human_projects <- available_projects()

## Explore the results
dim(human_projects)
head(human_projects)

## How many are from a data source vs a compilation?
table(human_projects$project_type, useNA = "ifany")

## What are the unique file sources?
table(
    human_projects$file_source[human_projects$project_type == "data_sources"]
)

## Note that big projects are broken up to make them easier to access
## For example, GTEx and TCGA are broken up by tissue
head(subset(human_projects, file_source == "gtex"))
head(subset(human_projects, file_source == "tcga"))

## Find all the mouse projects
mouse_projects <- available_projects(organism = "mouse")

## Explore the results
dim(mouse_projects)
head(mouse_projects)

## How many are from a data source vs a compilation?
table(mouse_projects$project_type, useNA = "ifany")

## What are the unique file sources?
table(
    mouse_projects$file_source[mouse_projects$project_type == "data_sources"]
)

\dontrun{
## Use with a custom recount3_url:
available_projects(
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3test",
    available_homes = "data_sources/sra"
)

## You can also rely on project_homes() if the custom URL has a text file
## that can be read with readLines() at:
## <recount3_url>/<organism>/homes_index
available_projects(
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3test"
)
}
}
