% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_testDAA.R
\name{testDAA}
\alias{testDAA}
\alias{testDAA,phyloseq-method}
\alias{testDAA,matrix-method}
\title{A function to test for differential absolute abundance on a phyloseq object}
\usage{
testDAA(Y, ...)

\S4method{testDAA}{phyloseq}(Y, groupName, FCname, ...)

\S4method{testDAA}{matrix}(Y, FC, x, S = rowSums(Y), tieBreakRan = TRUE, assumeNormal = TRUE, ...)
}
\arguments{
\item{Y}{A phyloseq object, or a data matrix with samples in the rows and
OTUs in the columns}

\item{...}{passed on to the reconsi() function}

\item{groupName}{A character string, the name of a variable in physeq
indicating the grouping factor}

\item{FCname}{A character string, the name of a variable in physeq
containing the total cell count}

\item{FC}{a vector of length n with total flow cytometry cell counts}

\item{x}{a grouping factor of length n}

\item{S}{a vector of library sizes. Will be calculated if not provided}

\item{tieBreakRan}{A boolean, should ties be broken at random.}

\item{assumeNormal}{A boolean, should normality be assumed for the null distribution?}
}
\value{
See the reconsi() function
}
\description{
A function to test for differential absolute abundance on a phyloseq object
}
\examples{
#Test for phyloseq object
library(phyloseq)
data("VandeputteData")
VandeputtePruned = prune_samples(Vandeputte,
samples = sample_names(Vandeputte)[20:40])
testVanDePutte = testDAA(VandeputtePruned, "Health.status", "absCountFrozen",
B = 15)
#Test for matrix
testMat = testDAA(as(otu_table(VandeputtePruned), "matrix"),
get_variable(VandeputtePruned, "Health.status"),
get_variable(VandeputtePruned,"absCountFrozen"), B = 15)
}
