% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getG0.R
\name{getG0}
\alias{getG0}
\title{Obtain the consensus null}
\usage{
getG0(
  statObs,
  statsPerm,
  z0Quant,
  gridsize,
  maxIter,
  tol,
  estP0args,
  testPargs,
  B,
  p,
  pi0,
  assumeNormal,
  resamAssumeNormal
)
}
\arguments{
\item{statObs}{A vector of lenght p with observed test statistics}

\item{statsPerm}{A pxB matrix with permuation z-values}

\item{z0Quant}{a vector of length of quantiles defining the central part R
of the distribution. If a single number is supplied, then
(z0quant, 1-z0quant) will be used}

\item{gridsize}{An integer, the gridsize for the density estimation}

\item{maxIter}{An integer, the maximum number of iterations in determining R}

\item{tol}{The convergence tolerance.}

\item{estP0args}{A list of arguments passed on to the estP0args() function}

\item{testPargs}{A list of arguments passed on to quantileFun}

\item{B}{an integer, the number of permutations}

\item{p}{an integer, the number of hypotheses}

\item{pi0}{A known fraction of true null hypotheses}

\item{assumeNormal}{A boolean, should normality be assumed for the null distribution?}

\item{resamAssumeNormal}{A boolean, should normality be assumed for resampling dists}
}
\value{
A list with following entries
\item{PermDensFits}{The permutation density fits}
\item{zSeq}{The support of the kernel for density estimation}
\item{zValsDensObs}{The estimated densities of the observed z-values}
\item{convergence}{A boolean, has the algorithm converged?}
\item{weights}{Vector of length B with weights
   for the permutation distributions}
\item{fdr}{Estimated local false discovery rate along the support
   of the kernel}
\item{p0}{The estimated fraction of true null hypotheses}
\item{iter}{The number of iterations}
\item{fitAll}{The consensus null fit}
}
\description{
Obtain the consensus null
}
