% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{toMatrix}
\alias{toMatrix}
\title{Convert SummarizedExperiment or Dataframe to Matrix}
\usage{
toMatrix(m, rwnms = NA)
}
\arguments{
\item{m}{Can be a matrix, a data.frame, a DataFrame, or
SummarizedExperiment object.}

\item{rwnms}{the rownames of the object. If NA (the default),
assumes that the matrix-like object already has rownames, which
in this case do not need to be supplied separately.}
}
\value{
A matrix of expression values
}
\description{
This function converts SummarizedExperiment objects and dataframes
(both S3 and S4) to matrices of expression values. Used within receptLoss
functions to convert all matrix-like objects to the matrix class.
}
\examples{
m <- as.data.frame(matrix(data=rgamma(n=100, shape=3, rate=2),
nrow=10, ncol=10))
m <- toMatrix(m)
}
\keyword{internal}
