% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{receptLoss}
\alias{receptLoss}
\title{Identify genes with expression loss}
\usage{
receptLoss(exprMatrNml, exprMatrTum, nSdBelow, minPropPerGroup)
}
\arguments{
\item{exprMatrNml}{A matrix of expression values from normal tissue. Each row
is a gene, and each column is a patient or sample. Genes should be in same
order as exprMatrTum.}

\item{exprMatrTum}{A matrix of expression values from tumor tissue. Each row
is a gene, and each column is a patient or sample. Genes should be in same
order as exprMatrNml.}

\item{nSdBelow}{The number of SD below the mean of the adjacent normal tissue
to set the boundary between tumor subgroups.}

\item{minPropPerGroup}{A value between 0-1 that represents the minimum
proportion of samples that should be present in each of the two subgroups
(defined by the boundary set by nSdBelow) for a particular gene.}
}
\value{
a nx7 matrix, with n equaling the number of genes. The columns are
as follows:
\itemize{
\item geneNm - the gene name
\item lowerBound - the lower bound, or the value `nSdBelow` the mean of
the normal tissue expression data.
\item propTumLessThBound - the proportion of tumor samples with
expression levels less than `lowerBound`
\item muAb - "mu above", the mean expression value of tumors greater than
(ie above) the `lowerBound`.
\item `muBl` - "mu below", the mean expression value of tumors less than
(ie below) the `lowerBound`.
\item `deltaMu` - the difference between `muAb` and `muBl`.
\item meetsMinPropPerGrp - a logical indicating whether the proportion
of samples in each group is greater than that set by `minPropPerGroup`.
}
}
\description{
This function allows you to identify genes with loss of expression
}
\examples{
exprMatrNml <- matrix(abs(rnorm(100, mean=2)), nrow=10)
exprMatrTum <- matrix(abs(rnorm(100)), nrow=10)
geneNames <- paste0(letters[seq_len(nrow(exprMatrNml))],
seq_len(nrow(exprMatrNml)))
rownames(exprMatrNml) <- rownames(exprMatrTum) <- geneNames
nSdBelow <- 2
minPropPerGroup <- .2
rl <- receptLoss(exprMatrNml, exprMatrTum, nSdBelow, minPropPerGroup)
head(rl)
}
\keyword{expression,}
\keyword{gene}
\keyword{subgroups}
