% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{plotReceptLoss}
\alias{plotReceptLoss}
\title{Plot histogram of genes with expression loss}
\usage{
plotReceptLoss(exprMatrNml, exprMatrTum, rldf, geneName, addToTitle = "", clrs)
}
\arguments{
\item{exprMatrNml}{A matrix of expression values from normal tissue.
Each row is a gene, and each column is a patient or sample. Genes should
be in same order as exprMatrTum.}

\item{exprMatrTum}{A matrix of expression values from tumor tissue. Each row
is a gene, and each column is a patient or sample. Genes should be in same
order as exprMatrNml.}

\item{rldf}{The dataframe output from running the receptLoss function}

\item{geneName}{The name of the gene to plot. The name of the gene should
correspond to a row name in both exprMatrNml and exprMatrTum matrices.}

\item{addToTitle}{A string that can be added to the title, which includes
the gene name.}

\item{clrs}{Vector of length 2 containing colors to use for plot}
}
\value{
returns an object of class `ggplot`
}
\description{
This function allows you to plot histograms of tumor and adj normal data
}
\examples{
exprMatrNml <- matrix(abs(rnorm(100, mean=2)), nrow=10)
exprMatrTum <- matrix(abs(rnorm(100)), nrow=10)
geneNames <- paste0(letters[seq_len(nrow(exprMatrNml))],
seq_len(nrow(exprMatrNml)))
rownames(exprMatrNml) <- rownames(exprMatrTum) <- geneNames
nSdBelow <- 2
minPropPerGroup <- .2
rl <- receptLoss(exprMatrNml, exprMatrTum, nSdBelow, minPropPerGroup)
clrs <- c("#E78AC3", "#8DA0CB")
plotReceptLoss(exprMatrNml, exprMatrTum, rl, geneName="g7", clrs=clrs)
}
\keyword{expression,}
\keyword{gene}
\keyword{subgroups,}
\keyword{visualization}
