% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd2id.R
\name{rmd2id}
\alias{rmd2id}
\title{Get the chapter identifier}
\usage{
rmd2id(path)
}
\arguments{
\item{path}{String containing the path to the Rmarkdown file for a chapter.}
}
\value{
String containing the identifier for this chapter.
If no identifier can be determined, \code{NULL} is returned.
}
\description{
Get the identifier for a book chapter given the Rmarkdown source code.
This is usually derived from the chapter title but can also be explicitly specified.
}
\examples{
tmp <- tempfile(fileext='.Rmd')
write('# some chapter name

blah', file=tmp)
rmd2id(tmp)

tmp2 <- tempfile(fileext='.Rmd')
write('# some chapter name {#chapter-id}

blah', file=tmp2)
rmd2id(tmp2)


}
\author{
Aaron Lun
}
