% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugActivityData.R
\name{getDrugActivityData}
\alias{getDrugActivityData}
\title{Returns a matrix containing activity (-logGI50) data for a set of compounds.}
\usage{
getDrugActivityData(nscSet, onlyCellMinerExps = TRUE)
}
\arguments{
\item{nscSet}{A string specifying the NSC identifiers for the compounds.}

\item{onlyCellMinerExps}{A logical value indicating whether to compute results
using only experimental data included in CellMiner (default=TRUE).}
}
\value{
a matrix with NCI-60 average (over experiments) -logGI50 activity
data; compound activity profiles are along rows.
}
\description{
Returns a matrix containing activity (-logGI50) data for a set of compounds.
}
\examples{
nscSet <- c("141540", "123127") # Etoposide, Doxorubicin.
actData <- getDrugActivityData(nscSet)

}
\concept{rcellminer}
