% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossCors.R
\name{crossCors}
\alias{crossCors}
\title{Calculate cross-correlations with between rows of input matrices}
\usage{
crossCors(X, Y = NULL, method = "pearson")
}
\arguments{
\item{X}{a matrix or data.frame}

\item{Y}{a matrix or data.frame}

\item{method}{a string specifying the type of correlation, chosen from pearson 
(default) or spearman.}
}
\value{
a list containing matrices of pairwise correlations and their p-values 
between rows of the input matrices or dataframes.
}
\description{
Calculate cross-correlations with between rows of input matrices
}
\examples{
drugActData <- exprs(getAct(rcellminerData::drugData))
crossCors(drugActData[c("94600"), ], drugActData[c("727625", "670655"), ])
crossCors(drugActData[c("94600"), ], drugActData[c("727625", "670655"), ], method="spearman")

}
\author{
Sudhir Varma, NCI-LMP, with input checks, support for Spearman's correlation
added by VNR.
}
\concept{rcellminer}
