% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawrr.R
\name{readIndex}
\alias{readIndex}
\title{Read scan index}
\usage{
readIndex(rawfile)
}
\arguments{
\item{rawfile}{the name of the raw file containing the mass spectrometry data from the Thermo Fisher Scientific instrument.}
}
\value{
returns a \code{data.frame} with the column names
scan, scanType, StartTime, precursorMass, MSOrder, charge, masterScan, and 
dependencyType of all spectra.
}
\description{
Read scan index
}
\examples{
Idx <- rawrr::sampleFilePath() |> rawrr::readIndex()
table(Idx$scanType)
plot(Idx$StartTime, Idx$precursorMass, col=as.factor(Idx$charge), pch=16)

table(Idx$MSOrder)
}
\author{
Tobias Kockmann and Christian Panse <cp@fgz.ethz.ch>, 2020, 2021
}
