% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{qqunif}
\alias{qqunif}
\title{Quantile-Quantile plot of data sample against uniform theoretical quantiles}
\usage{
qqunif(
  ps,
  log = "xy",
  pch = 20,
  xlab = "theoretical quantiles",
  ylab = "sample quantiles",
  plot.it = TRUE,
  ...
)
}
\arguments{
\item{ps}{\code{numeric} vector of values (e.g. p-values). Values must be
between 0 and 1. Values like \code{NA}, NaN, Inf etc. produce an error.}

\item{log}{\code{character} indicating whether axis should be plotted in log
scale. Either \code{""}, \code{"x"}, \code{"y"} or \code{"xy"}.}

\item{pch}{Point symbol, see \code{\link[graphics:par]{par}}.}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{plot.it}{\code{logical} whether the result should be plotted.}

\item{...}{Graphical parameters forwarded to \code{\link[stats:qqnorm]{qqplot}}}
}
\value{
A list of \code{x} and {y} coordinates, as in \code{\link[stats:qqnorm]{qqplot}}.
}
\description{
\code{qqunif} produces a QQ plot of the values in \code{ps} against the
theoretical quantiles of the uniform distribution.
}
\details{
This function can e.g. be used for comparing p-values against the uniform
distribution. The log scale of the x and y axes allow a closer look at low
p-values.

This function is a modified version of the examples in the
\code{\link[stats:qqnorm]{qqnorm}} documentation page.
}
\examples{
qqunif(runif(100))
}
