% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAMR.R
\name{plotAMR}
\alias{plotAMR}
\title{Plot aberrantly methylated regions}
\usage{
plotAMR(
  data.ranges,
  amr.ranges,
  data.samples = NULL,
  window = 300,
  ignore.strand = FALSE,
  highlight = NULL,
  title = NULL,
  labs = c("genomic position", "beta value"),
  transform = c("identity", "log1p", "log10"),
  limits = NULL,
  breaks = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data.ranges}{A `GRanges` object with genomic locations and
corresponding beta values included as metadata.}

\item{amr.ranges}{An output of `getAMR` - a `GRanges` object that contain
aberrantly methylated regions (AMRs).}

\item{data.samples}{A character vector with sample names (a subset of
metadata column names) to be included in the plot. If `NULL` (the default),
then all samples (metadata columns) are included.}

\item{window}{An optional integer constant to expand genomic ranges of the
`amr.ranges` object (the default: 300).}

\item{ignore.strand}{Boolean to ignore strand of AMR region. Default: FALSE.}

\item{highlight}{An optional list of samples to highlight. If NULL (the
default), will contain sample IDs from the `sample` metadata column of
`amr.ranges` object.}

\item{title}{An optional title for the plot. If NULL (the default), plot
title is set to a genomic location of particular AMR.}

\item{labs}{Optional axis labels for the plot. Default: c("genomic position",
"beta value").}

\item{transform}{Optional transformation of y-axis. Default: "identity"
(no transformation).}

\item{limits}{Optional limits of y-axis. When default (NULL), limits
are c(NA,1) for `transform=="log10"` and c(0,1) otherwise.}

\item{breaks}{Optional breaks of y-axis. When default (NULL), breaks
are `10**(seq(from=-5, to=0, length.out=6))` for `transform=="log10"` and
`seq(from=0, to=1, length.out=6)` otherwise.}

\item{verbose}{Boolean to report progress and timings (default: TRUE).}
}
\value{
The output is a list of `ggplot` objects.
}
\description{
`plotAMR` uses `ggplot2` to visualize aberrantly methylated regions (AMRs)
at particular genomic locations.
}
\details{
For every non-overlapping genomic location from `amr.ranges` object,
`plotAMR` plots and outputs a line graph of methylation beta values taken
from `data.ranges` for all samples from `data.samples`. Samples bearing
significantly different methylation profiles ('sample' column of
`amr.ranges` object) are highlighted.
}
\examples{
  data(ramr)
  plotAMR(data.ranges=ramr.data, amr.ranges=ramr.tp.unique[1])
  library(gridExtra)
  do.call("grid.arrange",
          c(plotAMR(data.ranges=ramr.data, amr.ranges=ramr.tp.nonunique), ncol=2))
}
\seealso{
\code{\link{getAMR}} for identification of AMRs,
\code{\link{getUniverse}} for info on enrichment analysis,
\code{\link{simulateAMR}} and \code{\link{simulateData}} for the generation
of simulated test data sets, and `ramr` vignettes for the description of
usage and sample data.
}
