test_simulateData.obsolete <- function () {
  data(ramr)
  RUnit::checkException(
    simulateData.obsolete("ramr.data", 2)
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data, nsamples=2, sample.names=c("a"))
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data, nsamples=2, amr.ranges=c("a"))
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data[1:100], nsamples=2, amr.ranges=ramr.tp.unique)
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data, nsamples=2, amr.ranges=ramr.tp.unique)
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data, nsamples=100, amr.ranges=ramr.tp.unique)
  )
  RUnit::checkException(
    simulateData.obsolete(ramr.data, nsamples=99, amr.ranges=ramr.tp.unique)
  )

  noise <- simulateAMR(ramr.data, nsamples=10, merge.window=1, min.cpgs=1, max.cpgs=1,
                       regions.per.sample=100, samples.per.region=1, dbeta=1)
  betas <- as.matrix(GenomicRanges::mcols( simulateData.obsolete(ramr.data, nsamples=10, amr.ranges=noise, cores=2) ))
  RUnit::checkEquals(
    dim(betas),
    c(3000, 10)
  )
  RUnit::checkTrue(
    sum( betas==0.999 | betas==0.001 ) >= length(noise)
  )
  noise <- simulateAMR(ramr.data, nsamples=10, merge.window=1, min.cpgs=1, max.cpgs=1,
                       regions.per.sample=100, samples.per.region=1, dbeta=NA)
  betas <- as.matrix(GenomicRanges::mcols( simulateData.obsolete(ramr.data, nsamples=10, amr.ranges=noise, cores=2) ))
  RUnit::checkTrue(
    sum(is.na(betas)) == length(noise)
  )

  ### if suggested library is not available
  test.env <- new.env()
  assign(x="is.test.environment", value=TRUE, envir=test.env)
  test.func <- function(f, env, ...) {
    environment(f) <- env
    f(...)
  }
  RUnit::checkException(
    test.func(f=simulateData.obsolete, env=test.env, ramr.data, nsamples=10, amr.ranges=noise, cores=2)
  )
}
