% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_AEI.R
\name{correct_strand}
\alias{correct_strand}
\title{Apply strand correction using gene annotations}
\usage{
correct_strand(rse, genes_gr)
}
\arguments{
\item{rse}{RangedSummarizedExperiment object containing editing sites
processed with "unstranded" setting}

\item{genes_gr}{GRanges object containing reference features to annotate the
strand of the editing sites.}
}
\value{
RangedSummarizedExperiment object containing pileup assays,
with strand corrected based on supplied genomic intervals.
}
\description{
Gene annotations are used to infer the likely strand of editing
sites. This function will operate on unstranded datasets which have been
processed using "unstranded" library type which reports variants
with respect to the + strand for all sites. The strand of the editing site
will be assigned the strand of overlapping features in the \code{genes_gr}
object. Sites with no-overlap, or overlapping features with conflicting
strands (+ and -) will be removed.
}
\examples{
suppressPackageStartupMessages(library("GenomicRanges"))

bamfn <- raer_example("SRR5564269_Aligned.sortedByCoord.out.md.bam")
fafn <- raer_example("human.fasta")
fp <- FilterParam(library_type = "unstranded")
rse <- pileup_sites(bamfn, fafn, param = fp)

genes <- GRanges(c(
    "DHFR:200-400:+",
    "SPCS3:100-200:-",
    "SSR3:3-10:-",
    "SSR3:6-12:+"
))

correct_strand(rse, genes)

}
