% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_editing.R
\name{calc_edit_frequency}
\alias{calc_edit_frequency}
\title{Adds editing frequencies}
\usage{
calc_edit_frequency(
  rse,
  edit_from = "A",
  edit_to = "G",
  drop = FALSE,
  replace_na = TRUE,
  edit_frequency = 0,
  min_count = 1
)
}
\arguments{
\item{rse}{A \link{RangedSummarizedExperiment} object created by \code{\link[=pileup_sites]{pileup_sites()}}}

\item{edit_from}{This should correspond to a nucleotide or assay
(\code{A}, \code{C}, \code{G}, \code{T}, \code{Ref}, or \code{Alt}) you expect in the reference. Ex. for
A to I editing events, this would be \code{A}.}

\item{edit_to}{This should correspond to a nucleotide or assay
(\code{A}, \code{C}, \code{G}, \code{T}, \code{Ref}, or \code{Alt})  you expect in the editing site. Ex.
for A to I editing events, this would be \code{G}.}

\item{drop}{If \code{TRUE}, the \link{RangedSummarizedExperiment} returned will only
retain sites matching the specified \code{edit_from} and \code{edit_to} bases.}

\item{replace_na}{If \code{TRUE}, \code{NA} and \code{NaN} editing frequencies will be
coerced to \code{0}.}

\item{edit_frequency}{The edit frequency cutoff used when calculating the
number of sites. Set to \code{0} to require any non-zero editing frequency. The
number of sites is stored as \code{n_sites} in the \code{colData}.}

\item{min_count}{The minimum number of reads required when enumerating number
of editing sites detected.}
}
\value{
\link{RangedSummarizedExperiment} supplemented with \code{edit_freq} and \code{depth} assay.
}
\description{
Adds editing frequencies to an existing
\link{RangedSummarizedExperiment} object (created by \code{\link[=pileup_sites]{pileup_sites()}}). The
\link{RangedSummarizedExperiment} with a new assay for editing frequencies
for each site (\code{edit_freq}), depth of coverage computed
using the indicated edited nucleotides (\code{depth}) and new \code{colData}
columns with the number of edited sites (\code{n_sites}) and the
fraction of edits (\code{edit_idx}) is returned.
}
\examples{
library(SummarizedExperiment)
rse_adar_ifn <- mock_rse()
rse <- calc_edit_frequency(rse_adar_ifn)
assay(rse, "edit_freq")[1:5, ]

}
