% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_links}
\alias{track_links}
\title{Generate links track}
\usage{
track_links(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  orientation = NULL,
  links_type = "arcs",
  line_width = NULL,
  line_style = "solid",
  color = "blue",
  alpha = 0.8,
  max_value = NULL,
  min_value = NULL,
  ylim = NULL,
  show_data_range = FALSE,
  compact_arcs_level = 0,
  use_middle = FALSE
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{orientation}{String. Default is NULL. Other option is "inverted".}

\item{links_type}{String value with options "arcs" (default) or "triangles" or "loops".}

\item{line_width}{Numeric value for line width.}

\item{line_style}{String with options of either "solid", "dashed", "dotted", and "dashdot".}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{alpha}{Numeric variable between 0 and 1 to indicate level of transparancy.
Default is 1.}

\item{max_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{min_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{ylim}{Numeric value above 0 to set arcs' height cutoff. Default is NULL}

\item{show_data_range}{Boolean. Default is TRUE.}

\item{compact_arcs_level}{Numeric value of either 0, 1 or 2
to indicate level of arcs' compactness by distance it travels.}

\item{use_middle}{Boolean. Default is FALSE.}
}
\value{
genome_track
}
\description{
Generate links track from arc file.
}
\details{
Level of compactness relative to arcs' length can be manipulated using the argument compact_arcs_level where:
\itemize{
\item{compact_arcs_level = 0, The default where the height is proportional to distance}
\item{compact_arcs_level = 1, the height is proportional to the square root of the distance}
\item{compact_arcs_level = 2, the height is the same for all distances}
}
ylim argument sets the cutoff for arcs' height.
This could be handy if you have small arc overridden by larger arc.
}
\note{
ylim argument is incompatible with compact_arcs_level = 2
}
\examples{
tads_dir <- system.file("extdata", "tad_classification.bed",
  package = "rGenomeTracks"
)
genes_dir <- system.file("extdata", "dm3_genes.bed.gz",
  package = "rGenomeTracks"
)
links_dir <- system.file("extdata", "test.arcs",
  package = "rGenomeTracks"
)
tads <- track_domains(tads_dir, color = "#cccccc", border_color = "red")
links_overlay <- track_links(links_dir,
  color = "red",
  line_width = 3, links_type = "loop",
  overlay_previous = "share-y"
)
links <- track_links(links_dir,
  color = "blue",
  line_width = 3, height = 3
)
genes <- track_bed(genes_dir,
  height = 7, style = "flybase",
  fontsize = 10
)
vlines <- track_vlines(genes_dir)
\dontrun{
plot_gtracks(tads + links_overlay + links + genes + vlines, chr = "X", start = 30 * 10^5, end = 35 * 10^5)
}
}
\author{
Omar Elashkar
}
