% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_epilogos}
\alias{track_epilogos}
\title{Generate epilogos track}
\usage{
track_epilogos(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  categories_file = NULL,
  orientation = NULL
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{categories_file}{Optionally pass a string of JSON custom colors configuration file directory. Default is NULL.}

\item{orientation}{String. Set to "inverted" to make the track upside down.
Default is NULL.}
}
\value{
None
}
\description{
Generate epilogos genome_track from qcat file.
}
\details{
Epilogos is used widely to represent multiple "states" across genome,
like ChromHMM states. More details \href{https://epilogos.altius.org/}{here}
\code{qcat} file is needed which can be generated using \href{https://github.com/Altius/epilogos}{epilogos}
\code{track_epiolog} can optionally take categories_file parameter which specify the color scheme for
the states present in \code{qcat} file. Check the example section for demonestration.
}
\note{
\code{fontsize} argument can be overriden by the same argument in \code{plot_gtracks()}
}
\examples{
epilog_dir <- system.file("extdata", "epilog.qcat.bgz", package = "rGenomeTracks")
epi_cat <- data.frame(
  category = 1:15,
  label = c(
    "Active TSS",
    "Flanking Active TSS",
    "Transcr at gene 5 and 3",
    "Strong transcription",
    "Weak transcription",
    "Genic enhancers",
    "Enhancers",
    "ZNF genes & repeats",
    "Heterochromatin",
    "Bivalent/Poised TSS",
    "Flanking Bivalent TSS/Enh",
    "Bivalent Enhancer",
    "Repressed PolyComb",
    "Weak Repressed PolyComb",
    "Quiescent/Low"
  ),
  color = c(
    "#ff0000", "#ff4500", "#32cd32", "#008000",
    "#006400", "#c2e105", "#ffff00", "#66cdaa",
    "#8a91d0", "#cd5c5c", "#e9967a", "#bdb76b",
    "#808080", "#c0c0c0", "#ffffff"
  )
)
epilog <- track_epilogos(file = epilog_dir, categories_file = epilogos_json(epi_cat))
\dontrun{
plot_gtracks(epilog, chr = "X", start = 3100000, 3150000)
}
}
\author{
Omar Elashkar
}
\keyword{epilogos_json}
