<!DOCTYPE html>
<!-- Generated by pkgdown: do not edit by hand --><html lang="en"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Perform online GREAT analysis — submitGreatJob • rGREAT</title><!-- jquery --><script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script><!-- Bootstrap --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css" integrity="sha256-bZLfwXAP04zRMK2BjiO8iu9pf4FbLqX6zitd+tIvLhE=" crossorigin="anonymous"><script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/js/bootstrap.min.js" integrity="sha256-nuL8/2cJ5NDSSwnKD8VqreErSWHtnEP9E7AySL+1ev4=" crossorigin="anonymous"></script><!-- bootstrap-toc --><link rel="stylesheet" href="../bootstrap-toc.css"><script src="../bootstrap-toc.js"></script><!-- Font Awesome icons --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/v4-shims.min.css" integrity="sha256-wZjR52fzng1pJHwx4aV2AO3yyTOXrcDW7jBpJtTwVxw=" crossorigin="anonymous"><!-- clipboard.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.6/clipboard.min.js" integrity="sha256-inc5kl9MA1hkeYUt+EC3BhlIgyp/2jDIyBLS6k3UxPI=" crossorigin="anonymous"></script><!-- headroom.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/headroom.min.js" integrity="sha256-AsUX4SJE1+yuDu5+mAVzJbuYNPHj/WroHuZ8Ir/CkE0=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script><!-- pkgdown --><link href="../pkgdown.css" rel="stylesheet"><script src="../pkgdown.js"></script><meta property="og:title" content="Perform online GREAT analysis — submitGreatJob"><meta property="og:description" content="Perform online GREAT analysis"><!-- mathjax --><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script><!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]--></head><body data-spy="scroll" data-target="#toc">
    

    <div class="container template-reference-topic">
      <header><div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">rGREAT</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="">2.5.3</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav"><li>
  <a href="../articles/install.html">Install</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu"><li class="dropdown-header">Online GREAT</li>
    <li>
      <a href="../articles/1.online-GREAT.html">Analyze with online GREAT</a>
    </li>
    <li class="divider">
    <li class="dropdown-header">Local GREAT</li>
    <li>
      <a href="../articles/2.local-GREAT.html">Analyze with local GREAT</a>
    </li>
    <li>
      <a href="../articles/3.other-geneset-databases.html">Work with other geneset databases</a>
    </li>
    <li>
      <a href="../articles/4.other-organisms.html">Work with other organisms</a>
    </li>
    <li class="divider">
    <li class="dropdown-header">Supplementaries in the rGREAT paper</li>
    <li>
      <a href="../articles/suppl_use_background.html">Suppl 1. Use background regions</a>
    </li>
    <li>
      <a href="../articles/suppl_compare_GO.html">Suppl 2. Compare GO annotations from online and local GREAT</a>
    </li>
    <li>
      <a href="../articles/suppl_compare_online_and_local.html">Suppl 3. Compare online and local GREAT</a>
    </li>
    <li>
      <a href="../articles/suppl_compare_tss.html">Suppl 4. Compare different TSS sources</a>
    </li>
    <li>
      <a href="../articles/suppl_compare_genome_version.html">Suppl 5. Compare different genome versions</a>
    </li>
  </ul></li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
      </ul><ul class="nav navbar-nav navbar-right"><li>
  <a href="https://github.com/jokergoo/rGREAT/" class="external-link">
    <span class="fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul></div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header><div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Perform online GREAT analysis</h1>
    
    <div class="hidden name"><code>submitGreatJob.rd</code></div>
    </div>

    <div class="ref-description">
    <p>Perform online GREAT analysis</p>
    </div>

    <div id="ref-usage">
    <div class="sourceCode"><pre class="sourceCode r"><code><span><span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span>, bg <span class="op">=</span> <span class="cn">NULL</span>,</span>
<span>    gr_is_zero_based      <span class="op">=</span> <span class="cn">FALSE</span>,</span>
<span>    species               <span class="op">=</span> <span class="st">"hg19"</span>,</span>
<span>    includeCuratedRegDoms <span class="op">=</span> <span class="cn">TRUE</span>,</span>
<span>    rule                  <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"basalPlusExt"</span>, <span class="st">"twoClosest"</span>, <span class="st">"oneClosest"</span><span class="op">)</span>,</span>
<span>    adv_upstream          <span class="op">=</span> <span class="fl">5.0</span>,</span>
<span>    adv_downstream        <span class="op">=</span> <span class="fl">1.0</span>,</span>
<span>    adv_span              <span class="op">=</span> <span class="fl">1000.0</span>,</span>
<span>    adv_twoDistance       <span class="op">=</span> <span class="fl">1000.0</span>,</span>
<span>    adv_oneDistance       <span class="op">=</span> <span class="fl">1000.0</span>,</span>
<span>    request_interval <span class="op">=</span> <span class="fl">60</span>,</span>
<span>    max_tries <span class="op">=</span> <span class="fl">10</span>,</span>
<span>    version <span class="op">=</span> <span class="va">DEFAULT_VERSION</span>,</span>
<span>    base_url <span class="op">=</span> <span class="st">"http://great.stanford.edu/public/cgi-bin"</span>,</span>
<span>    use_name_column <span class="op">=</span> <span class="cn">FALSE</span>,</span>
<span>    verbose <span class="op">=</span> <span class="va">help</span>, help <span class="op">=</span> <span class="va">great_opt</span><span class="op">$</span><span class="va">verbose</span><span class="op">)</span></span></code></pre></div>
    </div>

    <div id="arguments">
    <h2>Arguments</h2>
    <dl><dt>gr</dt>
<dd><p>A <code><a href="https://rdrr.io/pkg/GenomicRanges/man/GRanges-class.html" class="external-link">GRanges</a></code> object or a data frame which contains at least three columns (chr, start and end).</p></dd>

  <dt>bg</dt>
<dd><p>Not supported any more. See explanations in section "When_background_regions_are_set".</p></dd>

  <dt>gr_is_zero_based</dt>
<dd><p>Are start positions in <code>gr</code> zero-based?</p></dd>

  <dt>species</dt>
<dd><p>Species. "hg38", "hg19", "mm10", "mm9" are supported in GREAT version 4.x.x, "hg19", "mm10", "mm9", "danRer7" are supported in GREAT version 3.x.x and "hg19", "hg18", "mm9", "danRer7" are supported in GREAT version 2.x.x.</p></dd>

  <dt>includeCuratedRegDoms</dt>
<dd><p>Whether to include curated regulatory domains, see <a href="https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655443/Association+Rules#AssociationRules-CuratedRegulatoryDomains" class="external-link">https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655443/Association+Rules#AssociationRules-CuratedRegulatoryDomains</a> .</p></dd>

  <dt>rule</dt>
<dd><p>How to associate genomic regions to genes. See 'Details' section.</p></dd>

  <dt>adv_upstream</dt>
<dd><p>Unit: kb, only used when rule is <code>basalPlusExt</code>.</p></dd>

  <dt>adv_downstream</dt>
<dd><p>Unit: kb, only used when rule is <code>basalPlusExt</code>.</p></dd>

  <dt>adv_span</dt>
<dd><p>Unit: kb, only used when rule is <code>basalPlusExt</code>.</p></dd>

  <dt>adv_twoDistance</dt>
<dd><p>Unit: kb, only used when rule is <code>twoClosest</code>.</p></dd>

  <dt>adv_oneDistance</dt>
<dd><p>Unit: kb, only used when rule is <code>oneClosest</code>.</p></dd>

  <dt>request_interval</dt>
<dd><p>Time interval for two requests. Default is 300 seconds.</p></dd>

  <dt>max_tries</dt>
<dd><p>Maximal times for aotumatically reconnecting GREAT web server.</p></dd>

  <dt>version</dt>
<dd><p>Version of GREAT. The value should be "4.0.4", "3.0.0", "2.0.2". Shorten version numbers can also be used, such as using "4" or "4.0" is same as "4.0.4".</p></dd>

  <dt>base_url</dt>
<dd><p>the url of <code>cgi-bin</code> path, only used when it is explicitly specified.</p></dd>

  <dt>use_name_column</dt>
<dd><p>If the input is a data frame, whether to use the fourth column as the "names" of regions?</p></dd>

  <dt>verbose</dt>
<dd><p>Whether to print help messages.</p></dd>

  <dt>help</dt>
<dd><p>Whether to print help messages. This argument will be replaced by <code>verbose</code> in future versions.</p></dd>


</dl></div>
    <div id="details">
    <h2>Details</h2>
    <p>Note: On Aug 19 2019 GREAT released version 4(<a href="https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655442/Version+History" class="external-link">https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655442/Version+History</a> ) where it supports <code>hg38</code> genome and removes some ontologies such pathways. <code>submitGreatJob</code> still
takes <code>hg19</code> as default. <code>hg38</code> can be specified by the <code>species = "hg38"</code> argument.
To use the older versions such as 3.0.0, specify as <code>submitGreatJob(..., version = "3.0.0")</code>.</p>
<p>Note it does not use the standard GREAT API. This function directly send data to GREAT web server
by HTTP POST.</p>
<p>Following text is copied from GREAT web site ( <a href="http://great.stanford.edu/public/html/" class="external-link">http://great.stanford.edu/public/html/</a> )</p>
<p>Explanation of <code>rule</code> and settings with names started with 'adv_' (advanced settings):</p>
<dl><dt>basalPlusExt</dt>
<dd><p>Mode 'Basal plus extension'. Gene regulatory domain definition:  Each gene is assigned a basal regulatory domain of a minimum distance upstream  and downstream of the TSS (regardless of other nearby genes, controlled by <code>adv_upstream</code> and  <code>adv_downstream</code> argument). The gene regulatory domain is extended in both directions  to the nearest gene's basal domain but no more than the maximum extension in one direction (controlled by <code>adv_span</code>).</p></dd>

  <dt>twoClosest</dt>
<dd><p>Mode 'Two nearest genes'. Gene regulatory domain definition:  Each gene is assigned a regulatory domain that extends in both directions to the nearest  gene's TSS (controlled by <code>adv_twoDistance</code>) but no more than the maximum extension in one direction.</p></dd>

  <dt>oneClosest</dt>
<dd><p>Mode 'Single nearest gene'. Gene regulatory domain definition:  Each gene is assigned a regulatory domain that extends in both directions to the midpoint  between the gene's TSS and the nearest gene's TSS (controlled by <code>adv_oneDistance</code>) but no more than the maximum  extension in one direction.</p></dd>


</dl></div>
    <div id="when-background-regions-are-set">
    <h2>When_background_regions_are_set</h2>
    <p>Note when <code>bg</code> argument is set to a list of background regions, GREAT uses a completely different test!</p>
<p>When <code>bg</code> is set, <code>gr</code> should be exactly subset of <code>bg</code>. For example, let's say a background region list contains
five regions: <code>[1, 10], [15, 23], [34, 38], [40, 49], [54, 63]</code>, <code>gr</code> can only be a subset of the five regions, which
means <code>gr</code> can take <code>[15, 23], [40, 49]</code>, but it cannot take <code>[16, 20], [39, 51]</code>. In this setting, regions are taken
as single units and Fisher's exact test is applied for calculating the enrichment (by testing number of regions in the 2x2 contigency table).</p>
<p>Check <a href="https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655452/File+Formats#FileFormats-Whatshouldmybackgroundregionsfilecontain?" class="external-link">https://great-help.atlassian.net/wiki/spaces/GREAT/pages/655452/File+Formats#FileFormats-Whatshouldmybackgroundregionsfilecontain?</a> for more explanations.</p>
<p>Please note from rGREAT 1.99.0, setting <code>bg</code> is not supported any more and this argument will be removed in the future. You can either directly use GREAT website or use other Bioconductor packages such as "LOLA" to perform
the Fisher's exact test-based analysis.</p>
<p>If you want to restrict the input regions to background regions (by intersections) and still to apply Binomial test there, please
consider to use local GREAT by <code><a href="great.html">great</a></code>.</p>
    </div>
    <div id="value">
    <h2>Value</h2>
    

<p>A <code><a href="GreatJob-class.html">GreatJob-class</a></code> object which can be used to get results from GREAT server. The following methods can be applied on it:</p>


<ul><li><p><code><a href="getEnrichmentTables-GreatObject-method.html">getEnrichmentTables,GreatObject-method</a></code> to retreive the result tables.</p></li>
<li><p><code><a href="getRegionGeneAssociations-GreatObject-method.html">getRegionGeneAssociations,GreatObject-method</a></code> to get the associations between input regions and genes.</p></li>
<li><p><code><a href="plotRegionGeneAssociations-GreatObject-method.html">plotRegionGeneAssociations,GreatObject-method</a></code> to plot the associations bewteen input regions and genes.</p></li>
<li><p><code><a href="shinyReport-GreatObject-method.html">shinyReport,GreatObject-method</a></code> to view the results by a shiny application.</p></li>
</ul></div>
    <div id="see-also">
    <h2>See also</h2>
    <div class="dont-index"><p><code><a href="great.html">great</a></code> for the local implementation of GREAT algorithm.</p></div>
    </div>
    <div id="author">
    <h2>Author</h2>
    <p>Zuguang gu &lt;z.gu@dkfz.de&gt;</p>
    </div>

    <div id="ref-examples">
    <h2>Examples</h2>
    <div class="sourceCode"><pre class="sourceCode r"><code><span class="r-in"><span><span class="fu"><a href="https://rdrr.io/r/base/Random.html" class="external-link">set.seed</a></span><span class="op">(</span><span class="fl">123</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">gr</span> <span class="op">=</span> <span class="fu"><a href="randomRegions.html">randomRegions</a></span><span class="op">(</span>nr <span class="op">=</span> <span class="fl">1000</span>, genome <span class="op">=</span> <span class="st">"hg19"</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">job</span> <span class="op">=</span> <span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span><span class="op">)</span></span></span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> Note: On Aug 19 2019 GREAT released version 4 which supports hg38</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> genome and removes some ontologies such pathways. submitGreatJob()</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> still takes hg19 as default. hg38 can be specified by argument `species</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> = "hg38"`. To use the older versions such as 3.0.0, specify as</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> submitGreatJob(..., version = "3"). Set argument `help` to `FALSE` to</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> turn off this message.</span>
<span class="r-in"><span><span class="va">job</span></span></span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Submit time: 2024-02-27 08:58:47 </span>
<span class="r-out co"><span class="r-pr">#&gt;</span>   Note the results may only be avaiable on GREAT server for 24 hours.</span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Version: 4.0.4 </span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Species: hg19 </span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Inputs: 1000 regions</span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Mode: Basal plus extension </span>
<span class="r-out co"><span class="r-pr">#&gt;</span>   Proximal: 5 kb upstream, 1 kb downstream,</span>
<span class="r-out co"><span class="r-pr">#&gt;</span>   plus Distal: up to 1000 kb</span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Include curated regulatory domains</span>
<span class="r-out co"><span class="r-pr">#&gt;</span> </span>
<span class="r-out co"><span class="r-pr">#&gt;</span> Enrichment tables for following ontologies have been downloaded:</span>
<span class="r-out co"><span class="r-pr">#&gt;</span>   None</span>
<span class="r-out co"><span class="r-pr">#&gt;</span> </span>
<span class="r-in"><span></span></span>
<span class="r-in"><span><span class="co"># more parameters can be set for the job</span></span></span>
<span class="r-in"><span><span class="kw">if</span><span class="op">(</span><span class="cn">FALSE</span><span class="op">)</span> <span class="op">{</span> <span class="co"># suppress running it when building the package</span></span></span>
<span class="r-in"><span>    <span class="co"># current GREAT version is 4.0.4</span></span></span>
<span class="r-in"><span>    <span class="va">job</span> <span class="op">=</span> <span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span>, genome <span class="op">=</span> <span class="st">"hg19"</span><span class="op">)</span></span></span>
<span class="r-in"><span>    <span class="va">job</span> <span class="op">=</span> <span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span>, adv_upstream <span class="op">=</span> <span class="fl">10</span>, adv_downstream <span class="op">=</span> <span class="fl">2</span>, adv_span <span class="op">=</span> <span class="fl">2000</span><span class="op">)</span></span></span>
<span class="r-in"><span>    <span class="va">job</span> <span class="op">=</span> <span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span>, rule <span class="op">=</span> <span class="st">"twoClosest"</span>, adv_twoDistance <span class="op">=</span> <span class="fl">2000</span><span class="op">)</span></span></span>
<span class="r-in"><span>    <span class="va">job</span> <span class="op">=</span> <span class="fu">submitGreatJob</span><span class="op">(</span><span class="va">gr</span>, rule <span class="op">=</span> <span class="st">"oneClosest"</span>, adv_oneDistance <span class="op">=</span> <span class="fl">2000</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="op">}</span></span></span>
</code></pre></div>
    </div>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="pkgdown-sidebar">
    <nav id="toc" data-toggle="toc" class="sticky-top"><h2 data-toc-skip>Contents</h2>
    </nav></div>
</div>


      <footer><div class="copyright">
  <p></p><p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p></p><p>Site built with <a href="https://pkgdown.r-lib.org/" class="external-link">pkgdown</a> 2.0.7.</p>
</div>

      </footer></div>

  


  <style>nav[data-toggle='toc'] .nav .nav {display: block;}</style></body></html>

