% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeBiopax.R
\name{transitiveClosure}
\alias{transitiveClosure}
\title{This function generates the transitive closure of the supplied graph.}
\usage{
transitiveClosure(mygraph)
}
\arguments{
\item{mygraph}{graphNEL}
}
\value{
Returns the transitive closure of the supplied graph.
}
\description{
This function generates the transitive closure of the supplied graph. In short: if A->B->C then an edge A->C is added.
Edge weights are conserved if possible (in a hopefully smart way). This is a simple convenience wrapper for the RBGL function transitive.closure.
}
\examples{
# load data
data(biopaxexample)
pwid1 = "pid_p_100002_wntpathway"
pwid2 = "pid_p_100146_hespathway"
mygraph = pathway2RegulatoryGraph(biopax, pwid1)
tc = transitiveClosure(mygraph)
}
\author{
Frank Kramer
}
