% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeBiopax.R
\name{plotRegulatoryGraph}
\alias{plotRegulatoryGraph}
\title{This function layouts a regulatory graph and plots it using Rgraphviz.}
\usage{
plotRegulatoryGraph(mygraph, subgraphs = list(), layoutGraph = TRUE)
}
\arguments{
\item{mygraph}{graphNEL, regulatory graph}

\item{subgraphs}{list of character vectors with node names}

\item{layoutGraph}{logical. If FALSE the graph is not laid out again but send directly to Rgraphviz::renderGraph.}
}
\value{
none
}
\description{
This function takes a regulatory graph as generated by pathway2regulatoryGraph and plots it using standard layout options of layoutRegulatoryGraph.
This function is a wrapper for layoutRegulatoryGraph with standard parameters.
Subgraphs can be painted with different colors. This can be done by passing parameter subgraph a list of character vectors with node names.
}
\examples{
 # load data
 data(biopaxexample)
 pwid1 = "pid_p_100002_wntpathway"
 pwid2 = "pid_p_100146_hespathway"
 mygraph = pathway2RegulatoryGraph(biopax, pwid1)
 plotRegulatoryGraph(mygraph)
}
\author{
Frank Kramer
}
