% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiseqr_helpers.R
\name{quanTIseq}
\alias{quanTIseq}
\title{Run quanTIseq deconvolution}
\usage{
quanTIseq(currsig, currmix, scaling = TRUE, method = "lsei")
}
\arguments{
\item{currsig}{Signature matrix to be used for deconvolution (format: genes
by cell types).}

\item{currmix}{Mixture matrix to be deconvoluted (format: genes by samples).}

\item{scaling}{Logical value. If set to FALSE, it disables the correction
of cell-type-specific mRNA content bias. Default: TRUE}

\item{method}{Character string, defining the deconvolution method to be used:
\code{lsei} for constrained least squares regression, \code{hampel}, \code{huber}, or \code{bisquare}
for robust regression with Huber, Hampel, or Tukey bisquare estimators,
respectively. Default: \code{lsei}.}
}
\value{
A data.frame of cell fractions, cell types by samples.
}
\description{
Run quanTIseq deconvolution
}
\examples{

data(dataset_racle)
mixture <- dataset_racle$expr_mat
signature.file <- system.file(
  "extdata", "TIL10_signature.txt", package = "quantiseqr", mustWork = TRUE)
signature <- read.table(signature.file, header = TRUE, sep = "\t", row.names = 1)
# cellfrac <- quantiseqr:::quanTIseq(mixture, signature)
}
