% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts-data.R
\docType{data}
\name{transcripts}
\alias{transcripts}
\title{Transcripts for Degradation Models}
\format{
A \code{list()} of \code{tibble()}s containing the transcripts and adjusted
p-values selected by each model.
Each string is a GENCODE transcript IDs.
}
\usage{
transcripts
}
\description{
This object is a list of four \code{tibble}s where each element corresponds to the
top 10,000 transcripts (by significance) and their adjusted p-values for a
given degradation model. The \code{main_model} model is a linear model modelling
expression against a sample's degradation time, with brain region as a
covariate. The \code{int_model} model is similar but includes an interaction term
with degradation time and brain region. The \code{cell_main_model} and
\code{cell_int_model} models are like the respective \code{main_model} and \code{int_model}
models, but including cell-type fractions from deconvolution as linear terms.
}
\seealso{
\link{select_transcripts}
}
\keyword{datasets}
