% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qstats.R
\docType{methods}
\name{qstats}
\alias{qstats}
\title{qstats}
\usage{
qstats(object, group_factor, window = 0.05)
}
\arguments{
\item{object}{an object which is a data frame or 
matrix with observations (e.g. probes or genes) on 
the rows and samples as the columns.}

\item{group_factor}{a group level continuous or categorial 
covariate associated with each sample or column in the 
\code{object}. The order of the \code{group_factor} must 
match the order of the columns in \code{object}.}

\item{window}{window size for running median which is 
a fraction of the number of rows in \code{object}. 
Default is 0.05.}
}
\value{
A list of quantile statistics including 
\item{Q}{sample quantiles}
\item{Qref}{reference quantile}
\item{Qhat}{linear model fit at each quantile}
\item{SST}{total sum of squares}
\item{SSB}{between sum of squares}
\item{SSE}{within sum of squares}
\item{roughWeights}{SSE / SST}
\item{smoothWeights}{smoothed weights computed using a 
running median with a given \code{window} size.}
}
\description{
This function is a helper function that 
computes quantile statistics for the function 
\code{qsmooth}.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
qs <- qstats(object = dat, 
             group_factor = rep(c(0,1), each=10), 
             window = 0.05)

}
