% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsmooth.R
\docType{methods}
\name{qsmooth}
\alias{qsmooth}
\title{qsmooth}
\usage{
qsmooth(object, group_factor, batch = NULL, norm_factors = NULL, window = 0.05)
}
\arguments{
\item{object}{an object which is a \code{matrix} or 
\code{data.frame} with observations (e.g. probes or genes) on 
the rows and samples as the columns. Alternatively, 
a user can provide a \code{SummarizedExperiment} object
and the \code{assay(object, "counts")} will be used as input 
for the qsmooth normalization.}

\item{group_factor}{a group level continuous or categorial 
covariate associated with each sample or column in the 
\code{object}. The order of the \code{group_factor} must 
match the order of the columns in \code{object}.}

\item{batch}{(Optional) batch covariate (multiple 
batches are not allowed). 
If batch covariate is provided, \code{Combat()} from 
\code{sva} is used prior to qsmooth normalization to 
remove batch effects. See \code{Combat()} for more details.}

\item{norm_factors}{optional normalization scaling factors.}

\item{window}{window size for running median which is 
a fraction of the number of rows in \code{object}. 
Default is 0.05.}
}
\value{
A object of the class \code{qsmooth} that 
contains a numeric vector of the qsmooth weights in 
the \code{qsmoothWeights} slot and a matrix of normalized  
values after applying smoothed quantile normalization in 
the \code{qsmoothData} slot.
}
\description{
This function applies a generalization of 
quantile normalization called smoothed quantile 
normalization. This function defines the qsmooth class 
and constructor.
}
\details{
Quantile normalization is one of the most widely used 
normalization tools for data analysis in genomics. Although it 
was originally developed for gene expression microarrays it is
now used across many different high-throughput applications 
including RNAseq and ChIPseq. The methodology 
relies on the assumption that observed changes in the empirical 
distribution of samples are due to unwanted variability. 
Because the data is transformed to remove these differences 
it has the potential to remove interesting biologically driven
global variation. Therefore, applying quantile normalization, 
or other global normalization methods that rely on similar 
assumptions, may not be an appropriate depending on the type 
and source of variation. 

This function computes a weight at every 
quantile that compares the variability between groups 
relative to within groups. In one extreme quantile 
normalization is applied and in the other extreme quantile 
normalization within each biological condition is applied. 
The weight shrinks the group-level quantile normalized data 
towards the overall reference quantiles if variability 
between groups is sufficiently smaller than the variability 
within groups. 
See the vignette for more details.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
dat_qs <- qsmooth(object = dat, 
                  group_factor = rep(c(0,1), each=10))

}
