% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeFeatures-methods.R
\name{removeFeatures}
\alias{removeFeatures}
\alias{removeFeatures,ANY-method}
\alias{removeFeatures,SummarizedExperiment-method}
\title{Feature Filtering methods}
\usage{
\S4method{removeFeatures}{ANY}(x, method = c("missing", "blankratio", "rsd", "icc"), ...)

\S4method{removeFeatures}{SummarizedExperiment}(x, method = c("missing", "blankratio", "rsd", "icc"), i, ...)
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{method}{A string specifying which filtering method to use.}

\item{...}{Arguments passed to a specific filtering method.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}
}
\value{
A matrix or \linkS4class{SummarizedExperiment} object.
}
\description{
Removes Features based on missing values, QC and blank samples. See the
details below.
}
\details{
The method argument can be one of "missing", "blankratio", "rsd", "icc".
\itemize{
\item "missing" removes features based on proportions of missing values. Users
can specify one or more groups in samples. For multiple groups, a feature is
retained if there is at least one group with a proportion of non-missing
values above a cut-off.
\item For "blankratio", QC/blank intensity ratios are calculated for features
present at the blank samples. Features with a ratio below a cut-off will
be discarded.
\item "rsd" calculates a relative standard deviation (also known as
coefficient of variation) for each feature using QC samples. Features with a
RSD above a cut-off will be removed.
\item "icc" calculates an intraclass correlation coefficient (ICC) for each
feature using both biological and QC samples to identify how much of the
total variation is explained by biological variability, as described in
Schiffman, C et al (2019). Features with an ICC below a cut-off will be
removed.
}
}
\examples{

data(faahko_se)

g <- colData(faahko_se)$sample_group

## SummarizedExperiment object
se <- removeFeatures(faahko_se, i = "raw", method = "missing",
                     group = g, cut = 0.9)

## Matrix
m <- assay(faahko_se, i = "raw")
removeFeatures(m, method = "missing", group = g, levels = "WT", cut = 0.9)


}
\references{
Schiffman, C., Petrick, L., Perttula, K. et al. Filtering procedures for
untargeted LC-MS metabolomics data. BMC Bioinformatics 20, 334 (2019).
https://doi.org/10.1186/s12859-019-2871-9
}
\seealso{
See \link{removeMiss}, \link{removeBlankRatio}, \link{removeRSD}, and \link{removeICC}
for the underlying functions that do work.
}
