% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceFeatures-functions.R
\name{reducePCA}
\alias{reducePCA}
\title{Principal component analysis (PCA)}
\usage{
reducePCA(x, ncomp = 2, center = TRUE, scale = FALSE, ...)
}
\arguments{
\item{x}{A matrix-like object.}

\item{ncomp}{An integer specifying the number of components to extract.}

\item{center}{A logical specifying whether \code{x} needs to be mean-centered
prior to PCA.}

\item{scale}{A logical specifying whether the unit variance scaling needs to
be performed on \code{x} prior to PCA.}

\item{...}{Additional arguments passed to \link[pcaMethods:nipalsPca]{pcaMethods::nipalsPca}. Ignored
if \code{x} has no missing values.}
}
\value{
A reduced.pca object with the same number of rows as \code{ncol(x)}
containing the dimension reduction result.
}
\description{
Performs PCA on a matrix-like object where rows represent features and
columns represents samples.
}
\details{
For the data without missing values, PCA is performed with the transpose of
\code{x} via singular value decomposition. Otherwise, PCA is performed with the
transpose of \code{x} using the non-linear iterative partial least squares
(NIPALS) algorithm via the \link[pcaMethods:nipalsPca]{pcaMethods::nipalsPca}. The function returns a
\code{reduced.pca} object that is a matrix with custom attributes to summarize
(via \link{summary}) and visualize (via \link{plotReduced}) the PCA result. The custom
attributes include the following:
\itemize{
\item \code{method}: The method used to reduce the dimension of data.
\item \code{ncomp}: The number of components extracted.
\item \code{R2}: A vector indicating the amount of variance explained by each
principal component.
\item \code{R2cum}: A vector of cumulative R2.
\item \code{loadings}: A matrix of variable loadings.
\item \code{sdev}: A vector indicating the standard deviations of the principal
components.
\item \code{centered}: A logical indicating whether the data was mean-centered
prior to PCA.
\item \code{scaled}: A logical indicating whether the data was scaled prior to PCA.
}
}
\examples{

data(faahko_se)

m <- assay(faahko_se, "knn_vsn")
res <- reducePCA(m, ncomp = 3)
summary(res)

}
\references{
Wold, H. (1966). Estimation of principal components and related models by
iterative least squares. In P. R. Krishnajah (Ed.), Multivariate analysis
(pp. 391-420). NewYork: Academic Press.

Stacklies, W., Redestig, H., Scholz, M., Walther, D. and Selbig, J.
pcaMethods -- a Bioconductor package providing PCA methods for incomplete
data. Bioinformatics, 2007, 23, 1164-1167
}
\seealso{
See \link{reduceFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.

See \link{plotReduced} for visualization.

See \link[pcaMethods:nipalsPca]{pcaMethods::nipalsPca} for the underlying function that does the work.
}
