% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmtools-package.R
\docType{package}
\name{qmtools-package}
\alias{qmtools}
\alias{qmtools-package}
\title{qmtools: Quantitative Metabolomics Data Processing Tools}
\description{
The qmtools (quantitative metabolomics tools) package provides basic tools for processing quantitative metabolomics data with the standard SummarizedExperiment class. This includes functions for imputation, normalization, feature filtering, feature clustering, dimension-reduction, and visualization to help users prepare data for statistical analysis. This package also offers a convenient way to compute empirical Bayes statistics for which metabolic features are different between two sets of study samples. Several functions in this package could also be used in other types of omics data.
}
\details{
The qmtools package provides six categories of important functions:
\itemize{
\item Imputation: the \link{imputeIntensity} function performs data imputation on
missing values.
\item Normalization: the \link{normalizeIntensity} function performs data-driven
normalization on metabolomics data.
\item Feature filtering: the \link{removeFeatures} function removes uninformative
features based on missing values, QC and blank samples.
\item Feature clustering: the \link{clusterFeatures} function clusters metabolic
features according to their retention time and intensity correlation.
\item Dimension-reduction: the \link{reduceFeatures} function performs
dimensionality reduction.
\item Visualization: the \link{plotBox}, \link{plotCorr}, \link{plotMiss}, \link{plotReduced}, and
\link{plotRTgroup} functions help to visualize metabolomics data.
}

Please refer to the vignette to see how the aforementioned functions work.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/HimesGroup/qmtools}
  \item Report bugs at \url{https://github.com/HimesGroup/qmtools/issues}
}

}
\author{
\strong{Maintainer}: Jaehyun Joo \email{jaehyunjoo@outlook.com}

Authors:
\itemize{
  \item Blanca Himes \email{bhimes@pennmedicine.upenn.edu}
}

}
\keyword{internal}
