% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSites.R
\name{mergeSites}
\alias{mergeSites}
\title{Merge identical modification sites intensities}
\usage{
mergeSites(MSnSetObj, summarizationFunction, annotation, keepCols = NULL)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{summarizationFunction}{function; method used to aggregate the
peptides. sum, mean or median}

\item{annotation}{data.frame; a data.frame of protein annotation of four
columns: "Accessions", "Gene", "Description" and "GeneSymbol"}

\item{keepCols}{a vector of additional columns from fData(MSnSetObj) to
keep.  either be a numeric vector of column indices or a character vector of
column names}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}})
}
\description{
Merge peptides with identical modification sites to single site intensity. This function is
especially useful for data based on enrichment of specific peptide modification.
}
\details{
Rows of the intensity matrix with identical sites on same protein are merged by
summarising the intensities using \code{summarizationFunction}. The merging will only take
place if "Sites" and "Type" column are present in the fData(MSnSetObj). Sites contains the 
information of modified site position within the protein sequence and Type tells us about
whether the modification is single (1xPhospho/Acetyl) or multi (2xPhospho/Acetyl).

Columns specified with \code{keepCols} are retained in the final output.
Non-unique entries in different rows are concatenated with ';'.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16),
                               Sequences=2, 
                               Accessions=6)
#MSnset_P <- mergeSites(MSnSet_data, sum, human_anno)

}
