% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePeptides.R
\name{mergePeptides}
\alias{mergePeptides}
\title{Merge identical modified peptides intensities}
\usage{
mergePeptides(MSnSetObj, summarizationFunction, annotation, keepCols = NULL)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{summarizationFunction}{function; method used to aggregate the
peptides. sum, mean or median}

\item{annotation}{data.frame; a data.frame of protein annotation of four
columns: "Accessions", "Gene", "Description" and "GeneSymbol"}

\item{keepCols}{a vector of additional columns from fData(MSnSetObj) to
keep.  either be a numeric vector of column indices or a character vector of
column names}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}})
}
\description{
Merge modified peptides with identical sequences to single peptide intensity. This function is
especially useful for modified peptide enrichment based method such as phosphopeptide analysis.
}
\details{
Rows of the intensity matrix with identical peptide sequences are merged by
summarising the intensities using \code{summarizationFunction}.

Columns specified with \code{keepCols} are retained in the final output.
Non-unique entries in different rows are concatenated with ';'.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16),
                               Sequences=2, 
                               Accessions=6)
MSnset_P <- mergePeptides(MSnSet_data, sum, human_anno)

}
