% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupScaling.R
\name{groupScaling}
\alias{groupScaling}
\title{Normalization by scaling within group}
\usage{
groupScaling(
  MSnSetObj,
  scalingFunction = median,
  groupingColumn = "SampleGroup"
)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{scalingFunction}{function; median or mean}

\item{groupingColumn}{character; the feature on which groups would be based;
default="SampleGroup"}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}})
}
\description{
Performs scaling normalization on the intensities within group (median or
mean)
}
\details{
In this normalization method the central tendencies (mean or median) of the
samples within groups are aligned. The argument "groupingColumn" is used to
define separate groups to normalize. The function takes one of the column of
pData(data) as the variable for classifying group. The default variable is
"SampleGroup".  It is imperative in qPLEX-RIME experiment to define IgG as a
separate group and normalize it separately from others. You could add a
column into the metadata to define this classification.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
MSnset_norm <- groupScaling(MSnSet_data, 
                            scalingFunction=median, 
                            groupingColumn="SampleGroup")

}
