% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefVar.R
\name{coefVar}
\alias{coefVar}
\title{Calculating the coefficient of variation by utilizing expression data within individual sample groups.}
\usage{
coefVar(MSnSetObj)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}
}
\value{
An object of class \code{list} consisting of object of class \code{ggplot})
}
\description{
Calculating the coefficient of variation by utilizing peptide/protein expression data within individual sample groups.
}
\details{
In this approach, we calculate distributions of the coefficient of variation (CV) 
for the dataset. The CVs are determined based on peptides or proteins intensities 
within each sample group, and the results are visualized through boxplots and 
cumulative fraction plots for each sample group.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
exprs(MSnSet_data) <- exprs(MSnSet_data)+1.1                                 
res <- coefVar(MSnSet_data)                             
}
