% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ptrSet-class}
\alias{ptrSet-class}
\title{A set of PTR-TOF-MS raw data informations}
\description{
A ptrSet object is related to a directory that contains several PTR-TOF-MS 
raw data in rhdf5 format. It is created 
with the \code{\link[ptairMS]{createPtrSet}} function. This object could be
updated when new files are added with the \code{\link[ptairMS]{updatePtrSet}}
function.
}
\section{Slots}{

\describe{
\item{\code{parameter}}{the input parameters value of the function 
\code{\link[ptairMS]{createPtrSet}} and \code{\link[ptairMS]{detectPeak}}}

\item{\code{sampleMetadata}}{dataframe of sample metadata, with file names 
in row names, suborders names and acquisition date in columns}

\item{\code{date}}{acquisition date for each file}

\item{\code{mzCalibRef}}{the masses used for calibration for each file}

\item{\code{signalCalibRef}}{the spectrum of mass calibration for each file}

\item{\code{errorCalibPpm}}{the calibration error for each file}

\item{\code{coefCalib}}{the coefficients of mass axis calibration of each calibration 
periods for each file}

\item{\code{indexTimeCalib}}{index time of each calibration period for each file}

\item{\code{primaryIon}}{the quantity in count per acquisition time of the isotope 
of primary ion for each file}

\item{\code{resolution}}{estimation of the resolution for each file based on the 
calibration reference masses}

\item{\code{prtReaction}}{drift information (temperature, pressure and voltage)}

\item{\code{ptrTransmisison}}{transmission curve for each file}

\item{\code{TIC}}{the total ion current (TIC) for each file}

\item{\code{breathTracer}}{the tracer for expiration/head spaces detection}

\item{\code{timeLimit}}{the index of time limit for each file}

\item{\code{knots}}{numeric vector correspond to the knot that will be used for the 
two dimensional regression for each file}

\item{\code{fctFit}}{the peak function used for peak deconvolution for each file}

\item{\code{peakShape}}{average normalized peak shape of the calibration peak for 
each file}

\item{\code{peakList}}{individual peak list in \code{\link[Biobase]{eSet}}}
}}

