% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ptrRaw-class}
\alias{ptrRaw-class}
\title{PTR-TOF-MS raw data from a rhdf5 file}
\description{
A ptrRaw object contains PTR-TOF-MS raw data from one rhdf5 file. It is 
created with the \code{\link[ptairMS]{readRaw}} function.
}
\section{Slots}{

\describe{
\item{\code{name}}{the file name}

\item{\code{rawM}}{the raw intensities matrix}

\item{\code{mz}}{array of the m/z axis}

\item{\code{time}}{numeric vector of acquisition time (in seconds)}

\item{\code{calibMzToTof}}{function to convert m/z to Tof}

\item{\code{calibToftoMz}}{function to convert tof to m/z}

\item{\code{calibCoef}}{calibration coefficients (a,b) such that: mz= ((tof-b)/a)^2 
for each calibration period}

\item{\code{indexTimeCalib}}{index time of each calibration period}

\item{\code{calibMassRef}}{the reference masses used for the calibration}

\item{\code{calibError}}{the shift error in ppm at the reference masses}

\item{\code{calibSpectr}}{the spectrum of calibration reference masses}

\item{\code{peakShape}}{average normalized peak shape of the calibration peak}

\item{\code{ptrTransmisison}}{matrix with transmission values}

\item{\code{prtReaction}}{a list containing PTR reaction information: drift 
temperature, pressure and voltage}

\item{\code{date}}{acquisition date and hour}

\item{\code{peakList}}{individual peak list in \code{\link[Biobase]{eSet}}}

\item{\code{fctFit}}{the peak function used for peak deconvolution for each file}

\item{\code{resolution}}{estimation of the resolution for each file based on the 
calibration reference masses}

\item{\code{primaryIon}}{the quantity in count per acquisition time of the isotope 
of primary ion for each file}
}}

\references{
https://www.hdfgroup.org
}
