% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R
\name{PeakList}
\alias{PeakList}
\alias{PeakList,ptrRaw-method}
\title{Detection and quantification of peaks on a sum spectrum.}
\usage{
PeakList(
  raw,
  mzNominal = unique(round(getRawInfo(raw)$mz)),
  ppm = 130,
  resolutionRange = c(3000, 5000, 8000),
  minIntensity = 5,
  fctFit = c("sech2", "averagePeak")[1],
  peakShape = NULL,
  maxIter = 1,
  R2min = 0.995,
  autocorNoiseMax = 0.3,
  plotFinal = FALSE,
  plotAll = FALSE,
  thNoiseRate = 1.1,
  minIntensityRate = 0.01,
  countFacFWHM = 10,
  daSeparation = 0.005,
  d = 3,
  windowSize = 0.4
)

\S4method{PeakList}{ptrRaw}(
  raw,
  mzNominal = unique(round(getRawInfo(raw)$mz)),
  ppm = 130,
  resolutionRange = c(300, 5000, 8000),
  minIntensity = 5,
  fctFit = c("sech2", "averagePeak")[1],
  peakShape = NULL,
  maxIter = 3,
  R2min = 0.995,
  autocorNoiseMax = 0.3,
  plotFinal = FALSE,
  plotAll = FALSE,
  thNoiseRate = 1.1,
  minIntensityRate = 0.01,
  countFacFWHM = 10,
  daSeparation = 0.005,
  d = 3,
  windowSize = 0.4
)
}
\arguments{
\item{raw}{\code{\link[ptairMS]{ptrRaw-class}} object}

\item{mzNominal}{the vector of nominal mass where peaks will be detected}

\item{ppm}{the minimum distance between two peeks in ppm}

\item{resolutionRange}{vector with resolution min, resolution Mean, and 
resolution max of the PTR}

\item{minIntensity}{the minimum intenisty for peaks detection. The final 
threshold for peak detection will be : max ( \code{minPeakDetect} , 
thresholdNoise ). The thresholdNoise correspond to 
max(\code{thNoiseRate} * max( noise around the nominal mass), \code{minIntensityRate} * 
 max( intenisty in the nominal mass). The noise around the nominal mass correspond : 
 \code{[m-windowSize-0.2,m-windowSize]U[m+windowSize,m+WindowSize+0.2]}.}

\item{fctFit}{the function for the quantification of Peak, should be average 
or Sech2}

\item{peakShape}{a list with reference axis and a reference peak shape 
centered in zero}

\item{maxIter}{maximum iteration of residual analysis}

\item{R2min}{R2 minimum to stop the iterative residual analysis}

\item{autocorNoiseMax}{the autocorelation threshold for Optimal windows 
Savitzky Golay 
filter in \code{OptimalWindowSG} ptairMS function. See \code{?OptimalWindowSG}}

\item{plotFinal}{boolean. If TRUE, plot the spectrum for all nominal masses, 
with the final fitted peaks}

\item{plotAll}{boolean. Tf TRUE, plot all step to get the final fitted peaks}

\item{thNoiseRate}{The rate which multiplies the max noise intensity}

\item{minIntensityRate}{The rate which multiplies the max signal intensity}

\item{countFacFWHM}{integer. We will sum the fitted peaks on a window's size 
of countFacFWHM * FWHM, centered in the mass peak center.}

\item{daSeparation}{the minimum distance between two peeks in Da for nominal 
mass < 17.}

\item{d}{the degree for the \code{Savitzky Golay} filtrer}

\item{windowSize}{peaks will be detected only around  m - windowSize ;
 m + windowSize, for all 
m in \code{mzNominal}}
}
\value{
a list containing: \itemize{
\item peak: a data.frame, with for all peak detected: the mass center, the 
intensity count in cps, the peak width (delta_mz), correspond to the Full Width Half 
Maximum (FWHM),the resolution m/delta_m, the other parameters values estimated 
of \code{fitFunc}.
\item warnings: warnings generated by the peak detection algorithm per nominal masses
\item infoPlot: elements needed to plot the fitted peak per nominal masses
}
}
\description{
Detection and quantification of peaks on a sum spectrum.
}
\examples{
library(ptairData)
filePath <- system.file('extdata/exhaledAir/ind1', 'ind1-1.h5', 
package = 'ptairData')
file <- readRaw(filePath)

peakList <- PeakList(file, mzNominal = c(21,63))
peakList$peak
}
