% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{testGroupIndependence}
\alias{testGroupIndependence}
\title{Multiple independence tests between reference groups and list of groups}
\usage{
testGroupIndependence(ref, groups, elements, pvalueAdjust = "BH")
}
\arguments{
\item{ref}{List of character: list of groups where each element contains the
identifiers of respective elements}

\item{groups}{List of characters: list of groups where each element contains
the identifiers of respective elements}

\item{elements}{Character: all available elements (if a data frame is given,
its rownames will be used)}

\item{pvalueAdjust}{Character: method used to adjust p-values (see Details)}
}
\value{
\code{multiGroupIndependenceTest} object, a data frame containing:
\item{attribute}{Name of the original groups compared against the reference
groups}
\item{table}{Contingency table used for testing}
\item{pvalue}{Fisher's exact test's p-value}
}
\description{
Test multiple contingency tables comprised by two groups (one reference group
and another containing remaining elements) and provided groups.
}
\details{
The following methods for p-value adjustment are supported by using
the respective string in the \code{pvalueAdjust} argument:
\itemize{
    \item{\code{none}: Do not adjust p-values}
    \item{\code{BH}: Benjamini-Hochberg's method (false discovery rate)}
    \item{\code{BY}: Benjamini-Yekutieli's method (false discovery rate)}
    \item{\code{bonferroni}: Bonferroni correction (family-wise error rate)}
    \item{\code{holm}: Holm's method (family-wise error rate)}
    \item{\code{hochberg}: Hochberg's method (family-wise error rate)}
    \item{\code{hommel}: Hommel's method (family-wise error rate)}
}
}
\examples{
elements <- paste("subjects", 1:10)
ref      <- elements[5:10]
groups   <- list(race=list(asian=elements[1:3],
                           white=elements[4:7],
                           black=elements[8:10]),
                 region=list(european=elements[c(4, 5, 9)],
                             african=elements[c(6:8, 10)]))
groupTesting <- testGroupIndependence(ref, groups, elements)
# View(groupTesting)
}
\seealso{
\code{\link{parseCategoricalGroups}()} and
\code{\link{plotGroupIndependence}()}

Other functions for data grouping: 
\code{\link{createGroupByAttribute}()},
\code{\link{getGeneList}()},
\code{\link{getSampleFromSubject}()},
\code{\link{getSubjectFromSample}()},
\code{\link{groupPerElem}()},
\code{\link{plotGroupIndependence}()}
}
\concept{functions for data grouping}
