% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interface.R
\name{showAlert}
\alias{showAlert}
\alias{successAlert}
\alias{errorAlert}
\alias{warningAlert}
\alias{removeAlert}
\title{Show or remove an alert}
\usage{
showAlert(
  session,
  ...,
  title,
  style = NULL,
  dismissible = TRUE,
  alertId = "alert",
  iconName = NULL,
  caller = NULL
)

successAlert(
  session,
  ...,
  title = NULL,
  dismissible = TRUE,
  alertId = "success",
  caller = NULL
)

errorAlert(
  session,
  ...,
  title = NULL,
  dismissible = TRUE,
  alertId = "alert",
  caller = NULL
)

warningAlert(
  session,
  ...,
  title = NULL,
  dismissible = TRUE,
  alertId = "alert",
  caller = NULL
)

removeAlert(output, alertId = "alert")
}
\arguments{
\item{session}{Shiny session}

\item{...}{Arguments to render as elements of alert}

\item{title}{Character: title}

\item{style}{Character: style (\code{error}, \code{warning} or \code{NULL})}

\item{dismissible}{Boolean: is the alert dismissible?}

\item{alertId}{Character: identifier}

\item{iconName}{Character: icon name}

\item{caller}{Character: caller module identifier}

\item{output}{Shiny output}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Show or remove an alert
}
\seealso{
\code{\link{showModal}()}
}
\keyword{internal}
