% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_information.R
\name{queryEnsemblByGene}
\alias{queryEnsemblByGene}
\alias{queryEnsemblByEvent}
\title{Query information from Ensembl}
\usage{
queryEnsemblByGene(gene, species = NULL, assembly = NULL)

queryEnsemblByEvent(event, species = NULL, assembly = NULL, data = NULL)
}
\arguments{
\item{gene}{Character: gene}

\item{species}{Character: species (may be \code{NULL} for an Ensembl
identifier)}

\item{assembly}{Character: assembly version (may be NULL for an Ensembl
identifier)}

\item{event}{Character: alternative splicing event}

\item{data}{Matrix or data frame: alternative splicing information}
}
\value{
Information from Ensembl
}
\description{
Query information from Ensembl
}
\examples{
queryEnsemblByGene("BRCA1", "human", "hg19")
queryEnsemblByGene("ENSG00000139618")
event <- "SE_17_-_41251792_41249306_41249261_41246877_BRCA1"
queryEnsemblByEvent(event, species="human", assembly="hg19")
}
\seealso{
Other functions to retrieve external information: 
\code{\link{ensemblToUniprot}()},
\code{\link{plotProtein}()},
\code{\link{plotTranscripts}()}
}
\concept{functions to retrieve external information}
