% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_correlation.R
\name{[.GEandAScorrelation}
\alias{[.GEandAScorrelation}
\alias{plot.GEandAScorrelation}
\alias{plotCorrelation}
\alias{print.GEandAScorrelation}
\alias{as.table.GEandAScorrelation}
\title{Display results of correlation analyses}
\usage{
\method{[}{GEandAScorrelation}(x, genes = NULL, ASevents = NULL)

\method{plot}{GEandAScorrelation}(
  x,
  autoZoom = FALSE,
  loessSmooth = TRUE,
  loessFamily = c("gaussian", "symmetric"),
  colour = "black",
  alpha = 0.2,
  size = 1.5,
  loessColour = "red",
  loessAlpha = 1,
  loessWidth = 0.5,
  fontSize = 12,
  ...,
  colourGroups = NULL,
  legend = FALSE,
  showAllData = TRUE,
  density = FALSE,
  densityColour = "blue",
  densityWidth = 0.5
)

\method{print}{GEandAScorrelation}(x, ...)

\method{as.table}{GEandAScorrelation}(x, pvalueAdjust = "BH", ...)
}
\arguments{
\item{x}{\code{GEandAScorrelation} object obtained after running
\code{\link{correlateGEandAS}()}}

\item{genes}{Character: genes}

\item{ASevents}{Character: AS events}

\item{autoZoom}{Boolean: automatically set the range of PSI values based on
available data? If \code{FALSE}, the axis relative to PSI values will range
from 0 to 1}

\item{loessSmooth}{Boolean: plot a smooth curve computed by
\code{stats::loess.smooth}?}

\item{loessFamily}{Character: if \code{gaussian}, \code{loess} fitting is by
least-squares, and if \code{symmetric}, a re-descending M estimator is used}

\item{colour}{Character: points' colour}

\item{alpha}{Numeric: points' alpha}

\item{size}{Numeric: points' size}

\item{loessColour}{Character: loess line's colour}

\item{loessAlpha}{Numeric: loess line's opacity}

\item{loessWidth}{Numeric: loess line's width}

\item{fontSize}{Numeric: plot font size}

\item{...}{
  Arguments passed on to \code{\link[stats:scatter.smooth]{stats::loess.smooth}}
  \describe{
    \item{\code{span}}{smoothness parameter for \code{loess}.}
    \item{\code{degree}}{degree of local polynomial used.}
    \item{\code{evaluation}}{number of points at which to evaluate the smooth
    curve.}
  }}

\item{colourGroups}{List of characters: sample colouring by group}

\item{legend}{Boolean: show legend for sample colouring?}

\item{showAllData}{Boolean: show data outside selected groups as a single
group (coloured based on the \code{colour} argument)}

\item{density}{Boolean: contour plot of a density estimate}

\item{densityColour}{Character: line colour of contours}

\item{densityWidth}{Numeric: line width of contours}

\item{pvalueAdjust}{Character: method used to adjust p-values (see Details)}
}
\value{
Plots, summary tables or results of correlation analyses
}
\description{
Plot, print and display as table the results of gene expression and
alternative splicing
}
\details{
The following methods for p-value adjustment are supported by using the
respective string in the \code{pvalueAdjust} argument:
\itemize{
     \item{\code{none}: do not adjust p-values}
     \item{\code{BH}: Benjamini-Hochberg's method (false discovery rate)}
     \item{\code{BY}: Benjamini-Yekutieli's method (false discovery rate)}
     \item{\code{bonferroni}: Bonferroni correction (family-wise error rate)}
     \item{\code{holm}: Holm's method (family-wise error rate)}
     \item{\code{hochberg}: Hochberg's method (family-wise error rate)}
     \item{\code{hommel}: Hommel's method (family-wise error rate)}
}
}
\examples{
annot <- readFile("ex_splicing_annotation.RDS")
junctionQuant <- readFile("ex_junctionQuant.RDS")
psi <- quantifySplicing(annot, junctionQuant, eventType=c("SE", "MXE"))

geneExpr <- readFile("ex_gene_expression.RDS")
corr <- correlateGEandAS(geneExpr, psi, "ALDOA")

# Quick display of the correlation results per splicing event and gene
print(corr)

# Table summarising the correlation analysis results
as.table(corr)

# Correlation analysis plots
colourGroups <- list(Normal=paste("Normal", 1:3),
                     Tumour=paste("Cancer", 1:3))
attr(colourGroups, "Colour") <- c(Normal="#00C65A", Tumour="#EEE273")
plot(corr, colourGroups=colourGroups, alpha=1)
}
\seealso{
Other functions to correlate gene expression and alternative splicing: 
\code{\link{correlateGEandAS}()}

Other functions to correlate gene expression and alternative splicing: 
\code{\link{correlateGEandAS}()}
}
\concept{functions to correlate gene expression and alternative splicing}
