% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_vastTools.R
\name{parseVastToolsEvent}
\alias{parseVastToolsEvent}
\title{Parses an alternative splicing event from VAST-TOOLS}
\usage{
parseVastToolsEvent(event)
}
\arguments{
\item{event}{Data.frame: VAST-TOOLS event containing gene symbol, event ID,
length, junctions coordinates, event type and inclusion levels for both
samples}
}
\value{
List with the event attributes (chromosome, strand, event type and
the position of the exon boundaries)
}
\description{
Parses an alternative splicing event from VAST-TOOLS
}
\details{
Junctions are parsed from
}
\note{
Only supports to parse one event at a time.
}
\examples{
event <- read.table(text =
"NFYA HsaEX0042823 chr6:41046768-41046903 136 chr6:41040823,41046768-41046903,41051785 C2 0 N 0 N"
)
psichomics:::parseVastToolsEvent(event)
}
\keyword{internal}
