% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_local.R
\name{loadLocalFiles}
\alias{loadLocalFiles}
\title{Load local files}
\usage{
loadLocalFiles(
  folder,
  ignore = c(".aux.", ".mage-tab."),
  name = "Data",
  verbose = FALSE
)
}
\arguments{
\item{folder}{Character: path to folder or ZIP archive}

\item{ignore}{Character: skip folders and filenames that match the expression}

\item{name}{Character: name}

\item{verbose}{Boolean: print steps?}
}
\value{
List of data frames from valid files
}
\description{
Load local files
}
\examples{
\dontrun{
folder <- "~/Downloads/ACC 2016"
data <- loadLocalFiles(folder)

ignore <- c(".aux.", ".mage-tab.", "junction quantification")
loadLocalFiles(folder, ignore)
}
}
\seealso{
Other functions to load data: 
\code{\link{loadGtexData}()},
\code{\link{loadSRAproject}()},
\code{\link{loadTCGAdata}()}
}
\concept{functions to load data}
\concept{functions to load local files}
