% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_inclusionLevels.R
\name{loadAnnotation}
\alias{loadAnnotation}
\title{Load alternative splicing annotation from \code{AnnotationHub}}
\usage{
loadAnnotation(annotation, cache = getAnnotationHubOption("CACHE"))
}
\arguments{
\item{annotation}{Character: annotation to load}

\item{cache}{Character: path to \code{AnnotationHub} cache (used to load
alternative splicing event annotation)}
}
\value{
List of data frames containing the alternative splicing annotation
per event type
}
\description{
Load alternative splicing annotation from \code{AnnotationHub}
}
\examples{
human <- listSplicingAnnotations(species="Homo sapiens")[[1]]
\dontrun{
annot <- loadAnnotation(human)
}
}
\seealso{
Other functions for PSI quantification: 
\code{\link{filterPSI}()},
\code{\link{getSplicingEventTypes}()},
\code{\link{listSplicingAnnotations}()},
\code{\link{plotRowStats}()},
\code{\link{quantifySplicing}()}
}
\concept{functions for PSI quantification}
