% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interface.R
\name{colourInputMod}
\alias{colourInputMod}
\title{Modified colour input with 100\% width}
\usage{
colourInputMod(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[colourpicker:colourInput]{colourpicker::colourInput}}
  \describe{
    \item{\code{inputId}}{The \code{input} slot that will be used to access the value.}
    \item{\code{label}}{Display label for the control, or `\code{NULL} for no label.}
    \item{\code{value}}{Initial value (can be a colour name or HEX code)}
    \item{\code{showColour}}{Whether to show the chosen colour as text inside the input,
as the background colour of the input, or both (default).}
    \item{\code{palette}}{The type of colour palette to allow the user to select colours
from. \code{square} (default) shows a square colour palette that allows the
user to choose any colour, while \code{limited} only gives the user a
predefined list of colours to choose from.}
    \item{\code{allowedCols}}{A list of colours that the user can choose from. Only
applicable when \code{palette == "limited"}. The \code{limited} palette
uses a default list of 40 colours if \code{allowedCols} is not defined. If
the colour specified in \code{value} is not in the list, the default colour
will revert to black.}
    \item{\code{allowTransparent}}{If \code{TRUE}, enables a slider to choose an alpha
(transparency) value for the colour. When a colour with opacity is
chosen, the return value is an 8-digit HEX code.}
    \item{\code{returnName}}{If \code{TRUE}, then return the name of an R colour instead
of a HEX value when possible.}
    \item{\code{closeOnClick}}{If \code{TRUE}, then the colour selection panel will close
immediately after selecting a colour.}
    \item{\code{width}}{The width of the input, e.g. \code{"400px"} or \code{"100\%"}}
  }}
}
\value{
HTML elements
}
\description{
Modified colour input with 100\% width
}
\keyword{internal}
