% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_estimation_tag_functions.R
\name{cv_estimation}
\alias{cv_estimation}
\title{cv_estimation}
\usage{
cv_estimation(
  dataC,
  lab_replicates,
  sampleID_var = "sampleID",
  antigen_var = "antigen",
  replicate_var = "replicate",
  mfi_var = "FMedianBG_correct",
  cv_cut_off = 20
)
}
\arguments{
\item{dataC}{A dataset a data frame with feature variables to be used}

\item{lab_replicates}{A numeric value indicating the number of lab replicates}

\item{sampleID_var}{A character string containing the name of the sample 
identifier variable. Default set to 'sampleID'}

\item{antigen_var}{A character string containing the name of the 
features/protein variable. Default to 'antigen'}

\item{replicate_var}{A character string containing the name of the replicate
variable. Default to 'replicate'}

\item{mfi_var}{A character string containing the name of the variable with 
MFI value.Assuming background correction is done already.
Default to 'FMedianBG_correct'}

\item{cv_cut_off}{Optional value indicating the cut off of flagging CV's. 
Default set at 20.}
}
\value{
A data frame where CV's of the replicates have been calculated
}
\description{
A function to calculate the CV for the technical lab replicates.
 The default values are set as per the object names generated by machine
}
\details{
Coefficient of Variation
}
\examples{
dataC <- readr::read_csv(system.file("extdata", 
"dataC.csv", package="protGear"))
## this file has 3 lab replicates and the default names
cv_estimation(dataC  ,lab_replicates=3)
}
